﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;
using KeyConfig.Config;
using KeyConfig.Map;

namespace KeyConfig
{
	internal partial class ScreenEditor : EditorBase
	{
		internal ScreenEditor()
		{
			InitializeComponent();
		}

		ConfigData config;

		internal void InitializeEditor(ConfigData config)
		{
			this.config = config;

			if (config.FullScreen)
			{
				rdbFullScreen.Checked = true;
			}
			else
			{
				rdbWindow.Checked = true;
			}

			if (config.SyncTimer)
			{
				rdbSync.Checked = true;
			}
			else
			{
				rdbNoSync.Checked = true;
			}

			switch (config.SkipFrame)
			{
				case 0:
					rdbFrame60.Checked = true;
					break;
				case 1:
					rdbFrame30.Checked = true;
					break;
				case 2:
					rdbFrame20.Checked = true;
					break;
				case 3:
					rdbFrame15.Checked = true;
					break;
			}
			Edited = false;
		}

		private void rdbFullScreen_CheckedChanged(object sender, EventArgs e)
		{
			config.FullScreen = true;
			Edited = true;
		}

		private void rdbWindow_CheckedChanged(object sender, EventArgs e)
		{
			config.FullScreen = false;
			Edited = true;
		}

		private void rdbSync_CheckedChanged(object sender, EventArgs e)
		{
			config.SyncTimer = true;
			Edited = true;
		}

		private void rdbNoSync_CheckedChanged(object sender, EventArgs e)
		{
			config.SyncTimer = false;
			Edited = true;
		}

		private void rdbFrame60_CheckedChanged(object sender, EventArgs e)
		{
			config.SkipFrame = 0;
			Edited = true;
		}

		private void rdbFrame30_CheckedChanged(object sender, EventArgs e)
		{
			config.SkipFrame = 1;
			Edited = true;
		}

		private void rdbFrame20_CheckedChanged(object sender, EventArgs e)
		{
			config.SkipFrame = 2;
			Edited = true;
		}

		private void rdbFrame15_CheckedChanged(object sender, EventArgs e)
		{
			config.SkipFrame = 3;
			Edited = true;
		}

		internal Control FocusTarget
		{
			get { return rdbFullScreen; }
		}
	}
}